<?php

namespace Berkayk\OneSignal;

use Illuminate\Support\ServiceProvider;

class OneSignalServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $configPath = __DIR__ . '/../config/onesignal.php';

        $this->publishes([$configPath => config_path('onesignal.php')], 'config');
        $this->mergeConfigFrom($configPath, 'onesignal');

        if ($this->app instanceof Laravel\Lumen\Application) {
            $this->app->configure('onesignal');
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('onesignal', function ($app) {
            $config = isset($app['config']['services']['onesignal']) ? $app['config']['services']['onesignal'] : null;
            if (is_null($config)) {
                $config = $app['config']['onesignal'] ?: $app['config']['onesignal::config'];
            }
            //$config['app_id'] = 'dd9916ab-eba4-46a3-bb86-8bd7d7c4bc7f';
            //$config['rest_api_key'] = 'MjhhYTkxODctZmE5Mi00YmYxLWI3NTctNTczZDMwN2IxZjEw';
            //$config['user_auth_key'] = 'MWUyZjNiNWUtMGNiZS00ZjMxLWFmYmItZmU3Y2QxYjA3MTc5';

            error_log($config['app_id']);
            error_log($config['rest_api_key']);
            error_log($config['user_auth_key']);
            $client = new OneSignalClient($config['app_id'], $config['rest_api_key'], $config['user_auth_key']);

            return $client;
        });

        $this->app->alias('onesignal', 'Berkayk\OneSignal\OneSignalClient');
    }

    public function provides() {
        return ['onesignal'];
    }
}
