<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\RouteLogGps
 *
 * @property int $id
 * @property int $route_log_id
 * @property float $lat
 * @property float $lng
 * @property string $created_at
 * @property string $updated_at
 * @property RouteLog $routeLog
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps whereLat($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps whereLng($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps whereRouteLogId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogGps whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class RouteLogGps extends Model
{
    /**
     * @var array
     */
    protected $fillable = ['route_log_id', 'lat', 'lng', 'created_at', 'updated_at'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function routeLog()
    {
        return $this->belongsTo('App\Models\RouteLog');
    }
}