<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\RouteLog
 *
 * @property int $id
 * @property int $route_id
 * @property string $start
 * @property string $end
 * @property string $created_at
 * @property string $updated_at
 * @property Route $route
 * @property RouteLogGp[] $routeLogGps
 * @property RouteLogKid[] $routeLogKids
 * @property-read int|null $route_log_gps_count
 * @property-read int|null $route_log_kids_count
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog whereEnd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog whereRouteId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog whereStart($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLog whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class RouteLog extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'route_log';

    /**
     * @var array
     */
    protected $fillable = ['route_id', 'start', 'end', 'created_at', 'updated_at','status_route'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function route()
    {
        return $this->belongsTo('App\Models\Route');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function routeLogGps()
    {
        return $this->hasMany('App\Models\RouteLogGps');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function routeLogKids()
    {
        return $this->hasMany('App\Models\RouteLogKid');
    }
}