<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * App\Models\Kid
 *
 * @property int $id
 * @property int $school_id
 * @property string $first_name
 * @property string $last_name
 * @property string $birth_date
 * @property string $gender
 * @property string $nationality
 * @property string $identification
 * @property string $avatar
 * @property string $grade
 * @property string $address
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property School $school
 * @property Driver[] $drivers
 * @property User[] $users
 * @property string|null $medical_condition
 * @property int $status 0=en casa; 1=en ruta; 2=en colegio
 * @property-read int|null $drivers_count
 * @property-read int|null $users_count
 * @method static bool|null forceDelete()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid newQuery()
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Kid onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid query()
 * @method static bool|null restore()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereAvatar($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereBirthDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereFirstName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereGender($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereGrade($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereIdentification($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereLastName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereMedicalCondition($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereNationality($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereSchoolId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Kid withTrashed()
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Kid withoutTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Kid where($value,$value2)
 * @mixin \Eloquent
 */
class Kid extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'kid';
    
    use SoftDeletes;

    /**
     * @var array
     */
    protected $fillable = ['school_id', 'first_name', 'last_name', 'birth_date', 'gender', 'nationality', 'medical_condition',
    'identification', 'avatar', 'grade', 'address', 'created_at', 'updated_at', 'deleted_at', 'status'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function school()
    {
        return $this->belongsTo('App\Models\School');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function drivers()
    {
        return $this->belongsToMany('App\Models\Driver')->withPivot('status')->wherePivot('status', 1);;
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function users()
    {
        return $this->belongsToMany('App\Models\User', 'user_kid');
    }
    public function kidActiveRoutesPresent()
    {
        return $this->hasOne(KidActiveRoute::class,'id_kid')->orderBy('route_log_id', 'desc');
    }

}