<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

/**
 * App\Models\File
 *
 * @property int $id
 * @property string $name
 * @property string $filename
 * @property int $file_type_id
 * @property int $user_id
 * @property string $status
 * @property string $approval_date
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property FileType $file_type
 * @property User $user
 * @property-read mixed $status_text
 * @property-read mixed $url
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereApprovalDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereFileTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereFilename($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\File whereUserId($value)
 * @mixin \Eloquent
 */
class File extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'file';

    /**
     * @var array
     */
    protected $fillable = ['name', 'filename', 'file_type_id', 'user_id', 'status', 'approval_date',
    'created_at', 'updated_at', 'deleted_at'];

    protected $appends = ['statusText', 'url'];
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function file_type()
    {
        return $this->belongsTo('App\Models\FileType');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function getStatusTextAttribute()
    {
        switch ($this->status) {
            case 0:
                return 'Pendiente de aprobacion';
            case 1:
                return 'Validado';
            case 2:
                return 'Rechazado';
        }
    }
    
    public function getUrlAttribute()
    {
        return env('APP_URL').Storage::url('documents/'.$this->filename);
    }
}