<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Auth;
use Dingo\Api\Routing\Helpers;
use App\Traits\OneSignalMessages;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Response;
use Illuminate\Support\Facades\Log;
use App\Models\Notification;
use App\Models\kidActiveRoute;
use Config;
class UserController extends Controller
{
    use OneSignalMessages, Helpers;
    
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('jwt.auth', []);
    }

    public function showParent(Request $request, $id)
    {
        $user = User::with('kids.school', 'kids.drivers','kids.kidActiveRoutesPresent')->findOrFail($id);
        
        return response()->json($user);
    }
    
     public function update_password(Request $request, $id)
    {
        $dataPost = $request->input();
        
        $user = User::findOrFail($id);
        $user->password = $dataPost['password'];
        $user->update();
        
        return response()->json($user);
    }
    
    public function update(Request $request, $id)
    {
        $dataPost = $request->input();
        
        $user = User::findOrFail($id);
        $user->first_name = $dataPost['firstName'];
        $user->last_name = $dataPost['lastName'];
        $user->email = $dataPost['email'];
        $user->identification = $dataPost['identification'];
        $user->phone = $dataPost['contact'];
        $user->gender = $dataPost['gender'];
        $user->birth_date = $dataPost['birthDate'];
        $user->update();
        
        return response()->json($user);
    }
    
    
    
    public function update_onesignal(Request $request) {
            
        $user = $this->auth->user();
        $player_id = $request->input('user_id_token');

    //$player_id = '2626e4e1-3878-4f04-ab65-0dc82b99e3eb';

        $user = Auth::guard()->user();

        $appId = config('onesignal.app_id');


        $client = new Client([
            // Base URI is used with relative requests
            'base_uri' => 'https://onesignal.com',
            // You can set any number of default request options.
            'timeout'  => 5.0,
        ]);

        $response = $client->request('PUT', '/api/v1/players/'.$player_id, [
            'json' => [
                'app_id' => $appId,
                'external_user_id' => $user->id,
                'notification_types' => 1
            ]
        ]);




        return $response;
    }
    
    public function delete_onesignal(Request $request) {
            
        $user = $this->auth->user();
        $player_id = $request->input('user_id_token');
        
    //$player_id = '2626e4e1-3878-4f04-ab65-0dc82b99e3eb';
    
        $user = Auth::guard()->user();

        $appId = config('onesignal.app_id');
        
        $client = new Client([
            // Base URI is used with relative requests
            'base_uri' => 'https://onesignal.com',
            // You can set any number of default request options.
            'timeout'  => 5.0,
        ]);
        $response = $client->request('PUT', '/api/v1/players/'.$player_id, [
            'json' => [
                'app_id' => $appId,
                'external_user_id' => '',
                'notification_types' => 1
            ]
        ]);

        return $response;
    }
    
    public function uploadAvatar(Request $request) {
        
        $user = $this->auth->user();
        
        if ($user->avatar != null) {
             Storage::disk('avatars')->delete($user->avatar);
        }
        
        $avatar = $request->input('avatar');
        $image_data = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $avatar));
        $imageName = uniqid($user->id).'.jpg';

        $storage = Storage::disk('avatars')->put($user->id.'photoProfile.jpg', $image_data);
        $user->avatar = $imageName;
        $user->update();
        
        return response()->json($user);
    }
    
    
    
        public function getAvatar($id) {
        
              $user = $this->auth->user();
        
        $image_data = Storage::disk('avatars')->get($id.'photoProfile.jpg');
      
        $base64_image = base64_encode($image_data);

        return response()->json(['image_data' => 'data:image/jpeg;base64,' . $base64_image], 200);
    

    }

} 