<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\School;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Auth;

class SchoolController extends Controller
{
    
    public function index(Request $request)
    {
        $schools = School::get();
        
        return response()->json($schools);
    }
    
    public function show(Request $request, $id)
    {
        $school = School::findOrFail($id);
        
        return response()->json($school);
    }
    
    public function updateLocation(Request $request)
    {
        $schoolId = $request->input('school_id');
        $location = $request->input('location');
        $school = School::findOrFail($schoolId);
        $school->lat = $location['lat'];
        $school->lng = $location['lng'];
        $school->update();
        
        return response()->json($school);
    }
    
    public function searchSchools(Request $request)
    {
        $district = $request->input('district');
        $schools = School::with('drivers')->where('district', $district)->get();
        
        return response()->json($schools);
    }
} 