<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payment;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Auth;

class PaymentController extends Controller
{
    
    public function payer(Request $request, $id)
    {
        $payments = Payment::with('receiver', 'payer')->where('payer_id', $id)->get()->groupBy('status');
        
        return response()->json($payments);
    }
    
    public function receiver(Request $request, $id)
    {
        $payments = Payment::with('receiver', 'payer')->where('receiver_id', $id)->get()->groupBy('status');
        
        return response()->json($payments);
    }
    
    public function show(Request $request, $id)
    {
        $payment = Payment::findOrFail($id);
        
        return response()->json($payment);
    }
} 