<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Location;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Auth;

class LocationController extends Controller
{
    
    public function index(Request $request)
    {
        $locations = Location::select('id', 'name', 'region')->orderBy('id')->get()->groupBy('region');
        
        $orderedLocations = [];
        
        foreach ($locations as $region=>$location) {
            $orderedLocations[] = ['id'=> count($orderedLocations), 'name'=> $region, 'children' => $location];
            
        }
        
        return response()->json($orderedLocations);
    }
} 