<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\File;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Illuminate\Database\Eloquent\Builder;
use Auth;

class FileController extends Controller
{

    public function show(Request $request, $id)
    {
        $kid = File::with('users', 'school')->findOrFail($id);

        return response()->json($kid);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'birth_date' => 'nullable',
            'gender' => 'nullable',
            'nationality' => 'nullable',
            'identification' => 'required',
            'grade' => 'nullable',
            'school_id' => 'required',
            'medical_condition' => 'nullable',
            'address' => 'required',
            'status' => 'required',
        ]);
        $user_id = $request->input('user_id');
        $newFile = new File($validatedData);
        if (!$newFile->save()) {
            throw new HttpException(500);
        }
        if ($user_id !== null) {
            $newFile->users()->attach($user_id);
        }

        return response()->json($newFile);
    }

    public function delete(Request $request, $id)
    {
        $kid = File::findOrFail($id);
        $kid->delete();

        return response()->json($kid);
    }

    public function update(Request $request, $kid_id)
    {
        $validatedData = $request->validate([
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'birth_date' => 'nullable',
            'gender' => 'nullable',
            'nationality' => 'nullable',
            'identification' => 'required',
            'grade' => 'nullable',
            'school_id' => 'required',
            'medical_condition' => 'nullable',
            'address' => 'nullable',
        ]);

        $updatedFile = File::findOrFail($kid_id);
        $updatedFile->first_name = $validatedData['first_name'];
        $updatedFile->last_name = $validatedData['last_name'];
        if ($validatedData['birth_date'] !== '') {
            $updatedFile->birth_date = $validatedData['birth_date'];
        } else {
            $updatedFile->birth_date = null;
        }
        if ($validatedData['gender'] !== '') {
            $updatedFile->gender = $validatedData['gender'];
        } else {
            $updatedFile->gender = null;
        }
        if ($validatedData['nationality'] !== '') {
            $updatedFile->nationality = $validatedData['nationality'];
        } else {
            $updatedFile->nationality = null;
        }
        if ($validatedData['grade'] !== '') {
            $updatedFile->grade = $validatedData['grade'];
        } else {
            $updatedFile->grade = null;
        }
        if ($validatedData['medical_condition'] !== '') {
            $updatedFile->medical_condition = $validatedData['medical_condition'];
        } else {
            $updatedFile->medical_condition = null;
        }
        if ($validatedData['address'] !== '') {
            $updatedFile->address = $validatedData['address'];
        } else {
            $updatedFile->address = null;
        }
        $updatedFile->identification = $validatedData['identification'];
        $updatedFile->school_id = $validatedData['school_id'];

        $updatedFile->update();

        return response()->json($updatedFile);
    }
}
