<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Driver;
use App\Models\Kid;
use App\Models\User;
use App\Models\School;
use App\Models\DriverLocation;
use App\Models\DriverSchool;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Auth;

use App\Traits\OneSignalMessages;

class DriverController extends Controller
{
    use OneSignalMessages;
    
    public function show(Request $request, $id)
    {
        $driver = Driver::with('user', 'locations', 'schools', 'acceptedKids')->where('user_id', $id)->first();
        
        return response()->json($driver);
    }
    
    public function searchBuses(Request $request)
    {
        $school_id = $request->input('school_id');

             $school = School::with(['drivers.user' => function ($q) {
            $q->whereHas('driver', function ($q) {
                $q->where('validation', 'Autorizado/a');
            });
        }, 'drivers.acceptedKids'])->findOrFail($school_id);
        
        return response()->json($school->drivers);
    }
    
    public function update(Request $request, $id)
    {
        $dataPost = $request->input();
        
        $user = User::findOrFail($id);
        $user->first_name = $dataPost['firstName'];
        $user->last_name = $dataPost['lastName'];
        $user->gender = $dataPost['gender'];
        $user->email = $dataPost['email'];
        $user->identification = $dataPost['identification'];
        $user->nationality = $dataPost['nationality'];
        $user->phone = $dataPost['contact'];
        $user->update();
        
        $driver = Driver::with('user')->where('user_id', $id)->first();
        
        if (count($dataPost['availableLocations']) !== 0) {
            $driver->locations()->detach();
        }
        foreach ($dataPost['availableLocations'] as $location_id) {
            $driver->locations()->attach($location_id);
        }
        $driver->schools()->detach();
        foreach ($dataPost['schools'] as $school) {
            $driver->schools()->attach($school);
        }
        $driver->car_model = $dataPost['carModel'];
        $driver->car_plate = $dataPost['carPlate'];
        $driver->license_type = $dataPost['license'];
        $driver->capacity = $dataPost['capacity'];
        $driver->working_day = $dataPost['workingDay'];
        $driver->update();
        
        return response()->json($driver);
    }
    
    public function getDriverKids(Request $request, $id)
    {
        $kids = Driver::with('acceptedKids.school', 'schools', 'user')->where('user_id', $id)->first();
        
        return response()->json($kids);
    }
    
    public function addKidsToDriver(Request $request)
    {
        $dataPost = $request->input();
        $driver = Driver::with('user')->findOrFail($dataPost['driver_id']);
        
        $kid_ids = $dataPost['selectedKids'];

        foreach($kid_ids as $kid_id) {
            $driver->kids()->attach([$kid_id => ['status' => 0]]);
            $kid = Kid::findOrFail($kid_id);

            $this->sendNotificationKidToDriver($driver, $kid);
        }        
        
        return response()->json($driver);
    }
    
    public function acceptKid(Request $request)
    {
        $dataPost = $request->input();
        $driver = Driver::with('kids')->where('user_id', $dataPost['driver_id'])->first();
        
        $driver->pendingKids()->updateExistingPivot($dataPost['kid_id'], ['status' => 1]);
        $kid = Kid::with('users')->findOrFail($dataPost['kid_id']);
        $parents = $kid->users->pluck('id');
        $this->sendNotificationDriverToParentsAcceptKid($driver->user, $kid, $parents);
        
        return response()->json($driver);
    }
}